/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera;

import io.github.mortuusars.exposure.network.packet.Packet;
import io.github.mortuusars.exposure.network.packet.clientbound.ActiveCameraInHandSetS2CP;
import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.camera.CameraId;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import net.minecraft.class_1268;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class CameraInHand
extends Camera {
    protected final class_1268 hand;

    public CameraInHand(CameraHolder holder, CameraId cameraId, class_1268 hand) {
        super(holder, cameraId);
        this.hand = hand;
        if (!(holder instanceof class_1309)) {
            throw new IllegalStateException("Only LivingEntity can hold camera in hand." + String.valueOf(class_1299.method_5890((class_1299)holder.asHolderEntity().method_5864())) + " does snot have hands.");
        }
    }

    @Override
    public class_1799 getItemStack() {
        return ((class_1309)this.getHolder()).method_5998(this.getHand());
    }

    @Override
    public boolean deactivate() {
        CameraItem cameraItem;
        Object object;
        if (super.deactivate()) {
            return true;
        }
        class_1268 oppositeHand = this.getHand() == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808;
        class_1799 itemInHand = ((class_1309)this.getHolder()).method_5998(oppositeHand);
        if (this.getId().matches(itemInHand) && (object = itemInHand.method_7909()) instanceof CameraItem && (cameraItem = (CameraItem)((Object)object)).isActive(itemInHand)) {
            cameraItem.deactivate(this.getHolder().asHolderEntity(), itemInHand);
            return true;
        }
        object = this.getHolder();
        if (object instanceof class_1657) {
            class_1657 player = (class_1657)object;
            for (class_1799 stack : player.method_31548().field_7547) {
                CameraItem cameraItem2;
                class_1792 class_17922;
                if (!this.getId().matches(stack) || !((class_17922 = stack.method_7909()) instanceof CameraItem) || !(cameraItem2 = (CameraItem)class_17922).isActive(stack)) continue;
                cameraItem2.deactivate(this.getHolder().asHolderEntity(), stack);
                return true;
            }
        }
        return false;
    }

    @Override
    public Packet createSyncPacket() {
        return new ActiveCameraInHandSetS2CP(this.getHolder().asHolderEntity().method_5628(), this.getId(), this.getHand());
    }

    public class_1268 getHand() {
        return this.hand;
    }

    @Nullable
    public static CameraInHand find(CameraHolder holder) {
        class_1268[] class_1268Array = holder.asHolderEntity();
        if (class_1268Array instanceof class_1309) {
            class_1309 entity = (class_1309)class_1268Array;
            for (class_1268 hand : class_1268.values()) {
                class_1799 itemInHand = entity.method_5998(hand);
                class_1792 class_17922 = itemInHand.method_7909();
                if (!(class_17922 instanceof CameraItem)) continue;
                CameraItem cameraItem = (CameraItem)class_17922;
                return new CameraInHand(holder, cameraItem.getOrCreateID(itemInHand), hand);
            }
        }
        return null;
    }
}

